#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <FluxGarage_RoboEyes.h> 
#include <ESP32Servo.h> 

// ---------------- SERVO CONFIG ----------------
Servo headServo;
#define SERVO_PIN 3
#define HEAD_UP 180    // Normal upright position
#define HEAD_DOWN 160  // Tilted down position

// ---------------- OLED CONFIG ----------------
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET -1
#define OLED_ADDR 0x3C
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// ---------------- ROBO EYES ----------------
RoboEyes<Adafruit_SSD1306> roboEyes(display);

// ---------------- TIMING VARIABLES ----------------
unsigned long lastShakeTime = 0;
const unsigned long SHAKE_INTERVAL = 5000; // 5 Seconds

// ---------------- ANIMATION FUNCTION ----------------
void performTiredShake() {
  Serial.println("[DEMO] Getting Tired...");

  // 1. Change Mood
  roboEyes.setMood(TIRED);
  roboEyes.setPosition(S); // Look down

  // 2. Shake Head (Nod Down and Up twice)
  for (int i = 0; i < 2; i++) {
    
    // Go Down
    for (int pos = HEAD_UP; pos >= HEAD_DOWN; pos--) {
      headServo.write(pos);
      roboEyes.update(); // Keep animating eyes
      delay(15);
    }
    
    // Go Up
    for (int pos = HEAD_DOWN; pos <= HEAD_UP; pos++) {
      headServo.write(pos);
      roboEyes.update();
      delay(15);
    }
  }

  // 3. Return to Normal
  Serial.println("[DEMO] Happy again!");
  roboEyes.setMood(HAPPY);
  roboEyes.setPosition(DEFAULT);
}

// ---------------- SETUP ----------------
void setup() {
  Serial.begin(115200);
  Wire.begin();

  // Servo Init
  headServo.setPeriodHertz(50);
  headServo.attach(SERVO_PIN, 500, 2400);
  headServo.write(HEAD_UP); // Start looking up

  // OLED Init
  if (!display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR)) {
    Serial.println("OLED init failed");
    while (1);
  }

  // RoboEyes Init
  roboEyes.begin(SCREEN_WIDTH, SCREEN_HEIGHT, 30);
  roboEyes.setMood(HAPPY);
  roboEyes.setAutoblinker(ON, 3, 2);
  
  // Make eyes cute and big
  roboEyes.eyeLwidthNext = 30;
  roboEyes.eyeRwidthNext = 30;
  roboEyes.eyeLheightNext = 25;
  roboEyes.eyeRheightNext = 25;

  Serial.println("Demo Started: Watch for shake every 5 seconds.");
}

// ---------------- MAIN LOOP ----------------
void loop() {
  // Always update eyes for smooth blinking/looking around
  roboEyes.update();

  // Check Time
  if (millis() - lastShakeTime > SHAKE_INTERVAL) {
    performTiredShake();
    lastShakeTime = millis(); // Reset timer
  }
}